/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#ifndef WAYLANDBACKEND_WLINTERFACE
#define WAYLANDBACKEND_WLINTERFACE 1

#include <string>
#include <wayland-client.h>

namespace WaylandBackend
{

class WLInterface
{
public:
    WLInterface() { }
    virtual ~WLInterface() { }
    
    virtual int init(struct wl_registry* registry, uint32_t name,
             const char* interface, uint32_t version) = 0;
    virtual uint32_t getWLID() = 0;
    virtual std::string& getWLName() = 0;
    
    virtual void surfaceDestroyNotification(struct wl_surface *wlSurface) { }
};

}

#endif
